<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Admin;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Tables\Admin\AdminTable;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;

final class AdminBuilder implements InterfaceAdminSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitAdminSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            AdminTable::USERNAME            => '',
            AdminTable::PASSWORD            => '',

            AdminTable::META_ACCESS         => '',
            AdminTable::META_LAST_ACTIVE    => System::isoDateTime(),

            AdminTable::STAMP_REGISTRATION  => System::isoDateTime(),
            AdminTable::STAMP_LAST_UPDATE   => System::isoDateTime(),
        );
    }

    public function dispense(): AdminModel
    {
        return AdminModel::createFromData(
            array(
                // username

                AdminTable::USERNAME => $this -> username

                ?? $this -> defaultValues[AdminTable::USERNAME],

                // password

                AdminTable::PASSWORD => $this -> password

                ?? $this -> defaultValues[AdminTable::PASSWORD],

                // meta access

                AdminTable::META_ACCESS => $this -> metaAccess

                ?? $this -> defaultValues[AdminTable::META_ACCESS],

                // meta last active

                AdminTable::META_LAST_ACTIVE => $this -> metaLastActive

                ?? $this -> defaultValues[AdminTable::META_LAST_ACTIVE],

                // stamp registration

                AdminTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[AdminTable::STAMP_REGISTRATION],

                // stamp last update

                AdminTable::STAMP_LAST_UPDATE => $this -> stampLastUpdate

                ?? $this -> defaultValues[AdminTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
